#include <ilcplex/cplex.h>
#include <string.h>
#include <values.h>
#include "global.h"
#include "cplex_struct.h"
#include "subset.h"

int feasibility(relaxation_matrix *r, int k, subset *s_best)
{
  cplex_struct *c = r->cplex;
  int ret = 1, i;
  
  int      cur_numrows,  cur_numcols;
  double   objval;
  double   *x = NULL;
  double   *pi = NULL;
  double   *slack = NULL;
  double   *dj = NULL;
  
  CPXENVptr     env = NULL;
  CPXLPptr      lp = NULL;
  int status = 0;
  
  subset_zero(s_best);

  c->rhs[0] = (double)k;

  env = CPXopenCPLEX (&status);
  if ( env == NULL ) {
    char  errmsg[1024];
    fprintf (stderr, "Could not open CPLEX environment.\n");
    CPXgeterrorstring (env, status, errmsg);
    fprintf (stderr, "%s", errmsg);
    ret = 0;
    goto TERMINATE;
  }
  
  /*  status = CPXsetintparam (env, CPX_PARAM_DATACHECK, CPX_ON);
  if ( status ) {
    fprintf (stderr, 
	     "Failure to turn on data checking, error %d.\n", status);
    ret = 0;
    goto TERMINATE;
    } */

  lp = CPXcreateprob (env, &status, "feasibility");
  if ( lp == NULL ) {
    fprintf (stderr, "Failed to create LP.\n");
    ret = 0;
    goto TERMINATE;
  }

  status = CPXcopylp (env, lp, c->number_of_columns, c->number_of_rows,
		      CPX_MAX, c->obj, c->rhs, c->sense, c->matbeg, c->matcnt,
		      c->matind, c->matval, c->lb, c->ub, NULL);
  if ( status ) {
    fprintf (stderr, "Failed to copy problem data %d.\n", status);
    ret = 0;
    goto TERMINATE;
  }

  status = CPXcopyctype (env, lp, c->ctype);
  if ( status ) {
    fprintf (stderr, "Failed to copy ctype\n");
    ret = 0;
    goto TERMINATE;
  }

  CPXsetintparam(env, CPX_PARAM_STARTALG, CPX_ALG_PRIMAL);
  CPXsetintparam(env, CPX_PARAM_SUBALG, CPX_ALG_PRIMAL);

  status = CPXmipopt (env, lp);
  if ( status ) {
    fprintf (stderr, "Failed to optimize LP.\n");
    ret = 0;
    goto TERMINATE;
  }
  
  status = CPXgetmipobjval (env, lp, &objval);
  if ( status ) {
    /* fprintf (stderr,"No MIP objective value available.  Exiting...\n"); */
    ret = 0;
    goto TERMINATE;
  }
  
  cur_numrows = CPXgetnumrows (env, lp);
  cur_numcols = CPXgetnumcols (env, lp);
  
  x = (double *) malloc (cur_numcols * sizeof(double));
  slack = (double *) malloc (cur_numrows * sizeof(double));
  dj = (double *) malloc (cur_numcols * sizeof(double));
  pi = (double *) malloc (cur_numrows * sizeof(double));
  
  if ( x     == NULL ||
       slack == NULL ||
       dj    == NULL ||
       pi    == NULL   ) {
    status = CPXERR_NO_MEMORY;
    fprintf (stderr, "Could not allocate memory for solution.\n");
    ret = 0;
    goto TERMINATE;
  }
  
  status = CPXgetmipx (env, lp, x, 0, cur_numcols-1);
  if ( status ) {
    fprintf (stderr, "Failed to get optimal integer x.\n");
    ret = 0;
    goto TERMINATE;
  }
  
  for (i=0; i<c->number_of_columns; i++)
    {
      if (fabs(x[i]) > EPSILON)
	subset_add(s_best, i);
    }
  
 TERMINATE:
  free(x);
  free(slack);
  free(dj);
  free(pi);

  if ( lp != NULL ) {
    status = CPXfreeprob (env, &lp);
    if ( status ) {
      fprintf (stderr, "CPXfreeprob failed, error code %d.\n", status);
    }
  }
  
  if ( env != NULL ) {
    status = CPXcloseCPLEX (&env);
    if ( status ) {
      char  errmsg[1024];
      fprintf (stderr, "Could not close CPLEX environment.\n");
      CPXgeterrorstring (env, status, errmsg);
      fprintf (stderr, "%s", errmsg);
    }
  }

  return ret;
}
