#include <string.h>
#include "global.h"
#include "util.h"
#include "cplex_struct.h"

static char relaxation_matrix_double(relaxation_matrix *r)
{
  int j;
  circle *tmp1;
  
  r->total_size *= 2;
  
  r->cplex->number_of_columns = r->number_of_circles;
  if (!cplex_struct_column_double(r->cplex))
    return 0;
  
  tmp1 = (circle *)malloc(r->total_size*sizeof(circle));
  if (!tmp1)
    return 0;
  
  for (j=0; j<r->number_of_circles; j++)
    circle_copy(&tmp1[j], &r->circles[j]);

  free (r->circles);
  r->circles = tmp1;
  
  return 1;
}

char relaxation_matrix_init(relaxation_matrix *r, subset *s)
{
  int i,j,z;
  circle c;
  double dummy;
  static char is_first = 1;

  r->number_of_points = s->size;
  r->number_of_circles = 0;
  if (is_first)
    {
      is_first = 0;
      r->cplex = cplex_struct_init();
      if (!r->cplex)
	return 0;
      r->total_size = MEMORY_CHUNK;
      r->circles = (circle *)malloc(MEMORY_CHUNK*sizeof(circle));
      if (!r->circles)
        return 0;
    }
  else
    cplex_struct_zero(r->cplex);
  
  while (r->cplex->max_rows < (s->size))
    cplex_struct_row_double(r->cplex);
  r->cplex->number_of_rows = (s->size);

  for (j=0; j<num_service_set_size; j++)    
    {
      double tmp = 0;
      
      for (i=0; i<s->size; i++)
	{
	  simple_circle(s->indices[i], j, &c);
	  if (c.r > coverage_distance)
	    continue;
	  tmp = c.r > tmp ? c.r : tmp;
	}
      c.r = tmp;
      c.index = j;
      
      if (r->number_of_circles == r->total_size)
	{
	  if (!relaxation_matrix_double(r))
	    return 0;
	}
      
      r->cplex->matbeg[r->cplex->number_of_columns] = r->cplex->nnz;
      if (r->cplex->nnz == r->cplex->max_nnz)
	{
	  if (!cplex_struct_nnz_double(r->cplex))
	    return 0;
	}
      //r->cplex->matind[r->cplex->nnz] = 0;
      //r->cplex->nnz ++;
      
      for (z=0; z<r->number_of_points; z++)
	{
	  if (in_circle(&c, s->indices[z], &dummy))
	  {
	    if (r->cplex->nnz == r->cplex->max_nnz)
	      {
		if (!cplex_struct_nnz_double(r->cplex))
		  return 0;
	      }
	    r->cplex->matind[r->cplex->nnz] = z;
	    r->cplex->nnz ++;
	  }
	}
      r->cplex->matcnt[r->cplex->number_of_columns] = r->cplex->nnz - 
	r->cplex->matbeg[r->cplex->number_of_columns];
      r->cplex->number_of_columns ++;

      circle_copy(&r->circles[r->number_of_circles], &c);
      r->number_of_circles++;
    }

  r->cplex->number_of_columns = r->number_of_circles;

  return 1;
}

char check_feasibility(relaxation_matrix *rel, subset *s,
		       double *new_solution_value)
{
  int i, j, k, cont;
  double *max_min_dist, r;

  max_min_dist = (double *)malloc(points_to_add*sizeof(double));

  for (i=0; i<points_to_add; i++)
  {
    farthest[i] = -1;
    max_min_dist[i] = 0;
  }

  for (i=0; i<num_demand_points; i++)
    {
      double min_dist = DBL_MAX;
      
      for (j=0; j<s->size; j++)
	{
	  in_circle(&rel->circles[s->indices[j]], i, &r);
	  if (r < min_dist)
	    min_dist = r;
	  /* if (r <= coverage_distance)
	    break; */
	}

      cont = 1;
      for (j=0; j<points_to_add && cont; j++)
      {
        if (min_dist > max_min_dist[j])
	{
	  for (k=points_to_add-1; k>j; k--)
	  {
	    farthest[k] = farthest[k-1];
	    max_min_dist[k] = max_min_dist[k-1];
	  }
	  farthest[j] = i;
	  max_min_dist[j] = min_dist;
	  cont = 0;
	}
      }
    }
  
  for(i=0; i<points_to_add; i++)
    {
      if (max_min_dist[i] <= coverage_distance)
        farthest[i] = -1;
    }

  if (max_min_dist[0] == 0)
  {
    *new_solution_value = 0;
    free(max_min_dist);
    return 1;
  }

  if (max_min_dist[0] <= coverage_distance)
  {
    *new_solution_value = max_min_dist[0];
    free(max_min_dist);
    return 1;
  }
  else
  {
    free(max_min_dist);
    return 0;
  }
}

void relaxation_matrix_zero(relaxation_matrix *r)
{
  r->number_of_circles = 0;
  cplex_struct_zero(r->cplex);
}

double get_solution_value(relaxation_matrix *r, subset *s)
{
  double ret = 0, tmp;
  int i;

  for (i=0; i<s->size; i++)
    {
      tmp = r->circles[s->indices[i]].r;
      if (tmp > ret)
	ret = tmp;
    }

  return ret;
}
