#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

#define MEMORY_CHUNK 10000
#define EPSILON 0.00000000001

typedef struct {
  int index;
} point;

typedef struct {
  int index;
  double r;
} circle;

typedef struct {
  int *indices;
  int size;
  int total_size;
} subset;

typedef struct {
  double *obj; /* size: number_of_columns */
  double *matval; /* size: nnz */
  int *matind; /* size: nnz */
  int *matbeg; /* size: number_of_columns */
  int *matcnt; /* size: number_of_columns */
  double *lb; /* size: number_of_columns */
  double *ub; /* size: number_of_columns */
  char *sense; /* size: number_of_rows */
  double *rhs; /* size: number_of_rows */
  char *ctype; /* size: number_of_columns */

  int number_of_rows;
  int number_of_columns;
  int nnz;
  int max_rows;
  int max_columns;
  int max_nnz;
} cplex_struct;

typedef struct {
  cplex_struct *cplex;
  circle *circles;
  int number_of_points;
  int number_of_circles;
  int total_size;
} relaxation_matrix;

extern int num_demand_points;
extern int num_service_set_size;
extern double coverage_distance;
extern double **distances;
extern int points_to_add, *farthest;

#endif
