#include "global.h"

char cplex_struct_column_double(cplex_struct *r)
{
  int i;
  int *tmp;
  
  r->max_columns *= 2;
  free(r->obj);
  r->obj = (double *)calloc(r->max_columns, sizeof(double));
  if (!r->obj)
    return 0;
  for (i=0; i<r->max_columns; i++)
    r->obj[i] = 1.0;
  tmp = (int *)malloc(r->max_columns * sizeof(int));
  if (!tmp)
    return 0;
  for (i=0; i<r->number_of_columns; i++)
    tmp[i] = r->matbeg[i];
  free(r->matbeg);
  r->matbeg = tmp;
  tmp = (int *)malloc(r->max_columns * sizeof(int));
  if (!tmp)
    return 0;
  for (i=0; i<r->number_of_columns; i++)
    tmp[i] = r->matcnt[i];
  free(r->matcnt);
  r->matcnt = tmp;
  free(r->lb);
  free(r->ub);
  free(r->ctype);
  r->lb = (double *)calloc(r->max_columns, sizeof(double));
  if (!r->lb)
    return 0;
  r->ub = (double *)malloc(r->max_columns * sizeof(double));
  if (!r->ub)
    return 0;
  for (i=0; i<r->max_columns; i++)
    r->ub[i] = 1.0;
  r->ctype = (char *)calloc(r->max_columns, sizeof(char));
  if (!r->ctype)
    return 0;
  for (i=0; i<r->max_columns; i++)
    r->ctype[i] = 'B';

  return 1;
}

char cplex_struct_row_double(cplex_struct *r)
{
  int i;
  
  r->max_rows *= 2;
  free(r->sense);
  r->sense = (char *)malloc(r->max_rows * sizeof(char));
  if (!r->sense)
    return 0;
  for (i=0; i<r->max_rows; i++)
    r->sense[i] = 'G';
  r->rhs = (double *)malloc(r->max_rows * sizeof(double));
  if (!r->rhs)
    return 0;
  for (i=0; i<r->max_rows; i++)
    r->rhs[i] = 1.0;
  
  return 1;
}

char cplex_struct_nnz_double(cplex_struct *r)
{
  int i;
  int *tmp;
  
  r->max_nnz *= 2;
  free(r->matval);
  r->matval = (double *)malloc(r->max_nnz * sizeof(double));
  if (!r->matval)
    return 0;
  for (i=0; i<r->max_nnz; i++)
    r->matval[i] = 1.0;
  tmp = (int *)malloc(r->max_nnz * sizeof(int));
  if (!tmp)
    return 0;
  for (i=0; i<r->nnz; i++)
    tmp[i] = r->matind[i];
  free(r->matind);
  r->matind = tmp;

  return 1;
}

cplex_struct *cplex_struct_init()
{
  cplex_struct *r;
  int i;
  
  r = (cplex_struct *)malloc(sizeof(cplex_struct));
  if (!r)
    return NULL;
  
  r->number_of_rows = 0;
  r->number_of_columns = 0;
  r->nnz = 0;
  r->max_rows = MEMORY_CHUNK;
  r->max_columns = MEMORY_CHUNK;
  r->max_nnz = 10*MEMORY_CHUNK;
  
  r->obj = (double *)calloc(r->max_columns, sizeof(double));
  r->matval = (double *)calloc(r->max_nnz, sizeof(double));
  r->matind = (int *)malloc(r->max_nnz * sizeof(int));
  r->matbeg = (int *)malloc(r->max_columns * sizeof(int));
  r->matcnt = (int *)malloc(r->max_columns * sizeof(int));
  r->lb = (double *)calloc(r->max_columns, sizeof(double));
  r->ub = (double *)malloc(r->max_columns * sizeof(double));
  r->sense = (char *)malloc(r->max_rows * sizeof(char));
  r->rhs = (double *)malloc(r->max_rows * sizeof(double));
  r->ctype = (char *)malloc(r->max_columns * sizeof(char));
  
  if (!r->obj || !r->matval || !r->matind || !r->matbeg || !r->matcnt ||
      !r->lb || !r->ub || !r->sense || !r->rhs || !r->ctype)
    {
      free(r->obj);
      free(r->matval);
      free(r->matind);
      free(r->matbeg);
      free(r->matcnt);
      free(r->lb);
      free(r->ub);
      free(r->sense);
      free(r->rhs);
      free(r->ctype);
      free(r);
      return NULL;
    }

  for (i=0; i<r->max_columns; i++)
    r->obj[i] = 1.0;
  for (i=0; i<r->max_nnz; i++)
    r->matval[i] = 1.0;
  for (i=0; i<r->max_columns; i++)
    r->ub[i] = 1.0;
  for (i=0; i<r->max_rows; i++)
    r->rhs[i] = 1.0;
  for (i=0; i<r->max_rows; i++)
    r->sense[i] = 'G';
  for (i=0; i<r->max_columns; i++)
    r->ctype[i] = 'B';
    
  return r;
}

void cplex_struct_zero(cplex_struct *r)
{
  r->number_of_rows = 0;
  r->number_of_columns = 0;
  r->nnz = 0;
}
