function []=unsharp_masking_demo()
% Demonstration of unsharp masking.

% Read the image of Lena
in_img=double(imread('lena.gif'));

% Obtain blurred image using convolution in spatial domain
blur_kernel=(1/25)*ones(5,5);
img_blurred=conv2(double(in_img),blur_kernel,'same');

% Perform unsharp masking using Laplacian filter with parameter ALPHA. 
% ALPHA controls the shape of the Laplacian and must be in the range 
% 0.0 to 1.0. The default ALPHA is 0.2.
lambda=0.5;
lambda2=0.5;
alpha=0.2;
h=[0 0 0;0 1 0;0 0 0] - fspecial('laplacian',alpha);

img_enhanced_edges=in_img+lambda*conv2(in_img,h,'same');

% Perform unsharp masking using the low pass filtered  image  with parameter lambda2. 
img_unsharp= in_img+lambda2*(in_img-img_blurred);

% Display the results
figure;
subplot(2,2,1);
imshow(in_img,[]);
title('Original image');
subplot(2,2,2);
imshow(img_blurred,[]);
title('Blurred image');
subplot(2,2,3);
imshow(img_enhanced_edges,[]);
title('Image after laplacian edge enhancement');
subplot(2,2,4);
imshow(img_unsharp,[]);
title('Image after low pass based unsharp masking');
