function []=conv_demo()
% Demonstration of computation of convolution using 2 methods:
% 1. direct method (in spatial domain);
% 2. indirect metod (in frequency domain).

%----The computation of convolution by direct method (in spatial domain)
img=zeros(100,100);
img(31:70,31:70)=255;
blur_kernel=(1/36)*ones(6,6);
img_blurred_using_spatial=conv2(img,blur_kernel,'same');

figure;
subplot(1,2,1);
imshow(img,[]);
title('The original image');
subplot(1,2,2);
imshow(img_blurred_using_spatial,[]);
title('The blurred image');

%---The computation of convolution by indirect method (in frequency domain)
img_spectrum=fftshift(fft2(img));
blur_kernel_spectrum=fftshift(fft2(blur_kernel,100,100));

img_blurred_spectrum=img_spectrum.*blur_kernel_spectrum;
img_blurred_using_dft=abs(ifft2(img_blurred_spectrum));

figure;
subplot(3,3,1);
imshow(img,[]);
title('Original image');
subplot(3,3,4);
imshow(20*log10(abs(img_spectrum)+1),[]);
title('Spectrum of orig. image');
subplot(3,3,5);
imshow(20*log10(abs(blur_kernel_spectrum)+1),[]);
title('Spectrum of blur. kernel');
subplot(3,3,6);
imshow(20*log10(abs(img_blurred_spectrum)+1),[]);
title('Spectrum of blur. image');
subplot(3,3,9);
imshow(img_blurred_using_dft,[]);
title('Blurred image');